const AUTOSET_WAIT = 0.5; //500[ms] 0-2.0
const AUTOSET_LAPS = 2; // 1-20
const SMA_SIZE = 6;     //100[ms] 1-20
const RC_FILTER = 0.70; //0.2-0.95

let connecting = false;
let inSession = false;
let filterReset = false;

// メーター
const meter = new SGTMeter();
meter.position = 1.0;
meter.ta = 1.0;

// Gauge
const GAUGE_MAX_VALUE = 360 / 2.5 * 200;
const COR_BASE = '#F8F8F8';  //全体
const COR_SCOPE = '#E0E0E0'; //通常範囲
const COR_RANGE = '#EEEEEE'; //その他範囲
const COR_WK = '#EFEFEF';    //薄い目盛
const COR_ST = '#C0C0C0';    //濃い目盛
const LW_WK = 8;
const LW_ST = 6;
const gaugeOpts = {
    angle: -0.5,
    lineWidth: 0.04,
    radiusScale: 1.2,
    pointer: {
        length: 0.50,
        strokeWidth: 0.005,
    },
    staticZones: [
        { strokeStyle: COR_BASE, min: 0, max: GAUGE_MAX_VALUE },  //全体
        { strokeStyle: COR_SCOPE, min: mv2gv(0), max: mv2gv(40) }, //目盛範囲
        { strokeStyle: COR_RANGE, min: mv2gv(0), max: mv2gv(2) },  //左側範囲
        { strokeStyle: COR_RANGE, min: mv2gv(12), max: mv2gv(18) },//セット範囲
        { strokeStyle: COR_RANGE, min: mv2gv(36), max: mv2gv(42) },//テスト範囲 + 余白
        { strokeStyle: COR_ST, min: mv2gv(0) - LW_ST, max: mv2gv(0) + LW_ST }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(2) - LW_WK, max: mv2gv(2) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(4) - LW_WK, max: mv2gv(4) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(6) - LW_WK, max: mv2gv(6) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(8) - LW_WK, max: mv2gv(8) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(10) - LW_WK, max: mv2gv(10) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(12) - LW_WK, max: mv2gv(12) + LW_WK }, //目盛
        { strokeStyle: COR_ST, min: mv2gv(15) - LW_ST, max: mv2gv(15) + LW_ST }, //セット
        { strokeStyle: COR_WK, min: mv2gv(18) - LW_WK, max: mv2gv(18) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(20) - LW_WK, max: mv2gv(20) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(22) - LW_WK, max: mv2gv(22) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(24) - LW_WK, max: mv2gv(24) + LW_WK }, //目盛
        { strokeStyle: COR_ST, min: mv2gv(26) - LW_ST, max: mv2gv(26) + LW_ST }, // Fall
        { strokeStyle: COR_WK, min: mv2gv(28) - LW_WK, max: mv2gv(28) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(30) - LW_WK, max: mv2gv(30) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(32) - LW_WK, max: mv2gv(32) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(34) - LW_WK, max: mv2gv(34) + LW_WK }, //目盛
        { strokeStyle: COR_WK, min: mv2gv(36) - LW_WK, max: mv2gv(36) + LW_WK }, //目盛
        { strokeStyle: COR_ST, min: mv2gv(40) - LW_ST, max: mv2gv(40) + LW_ST }, //目盛
    ],

};
const canvGauge = document.getElementById('CanvGauge');
const gauge = new Gauge(canvGauge);
function mv2gv(mv) { // meter値 → Gauge値
    return GAUGE_MAX_VALUE * (((mv / meter.scaleSize) * (105 / 360)) + (130 / 360));
}
gauge.animationSpeed = 1;
gauge.maxValue = GAUGE_MAX_VALUE;
gauge.setOptions(gaugeOpts);
gauge.setMinValue(0);
gauge.set(mv2gv(0));
canvGauge.addEventListener('click', () => { setPosition(); });

// 時計とセッション管理
const wTop = document.getElementById("DivTop");
const wCount = document.getElementById("WrapCount");
const wTime = document.getElementById("WrapTime");
const valNow = document.getElementById("ValNow");
const valElapsed = document.getElementById("ValElapsed");
const btnStart = document.getElementById("BtnStart");
const timeOffset = new Date(0).getTimezoneOffset() * 60 * 1000;
let sessionTime = 0;
let counterStart = 0;
function startClicked() {
    if (inSession) {
        inSession = false;
        appendMessage("ACTION  " + (counter - counterStart).toFixed(3));
        appendMessage("SESSION STOP\n");
        wCount.style.color = "gray";
        wTime.style.color = "gray";
        divStatus.style.fontWeight = "normal";
        if (connecting) {
            btnStart.textContent = "Session Start";
        } else {
            btnStart.textContent = "Connect";
        }
    } else if (!connecting) {
        start();
    } else {
        setPosition();
        appendMessage(null);
        appendMessage("SESSION START");
        appendMessage("COUNT " + counter.toFixed(3));
        appendMessage("SENS  " + meter.sens.toFixed(3));
        wCount.style.color = "black";
        wTime.style.color = "black";
        divStatus.style.fontWeight = "bold";
        btnStart.textContent = "Session Stop";
        lastSens = meter.sens;
        counterStart = counter;
        inSession = true;
    }
    btnStart.blur();
}
function tickTack() {
    const now = new Date();
    valNow.textContent = now.toLocaleDateString() + " - " + now.toLocaleTimeString();
    if (inSession) {
        sessionTime += 1000;
        valElapsed.textContent = new Date(sessionTime + timeOffset).toLocaleTimeString();
    }
}
btnStart.addEventListener("click", startClicked);

// アクションカウンター
const COUNT_HIST_SIZE = 2000;
const valCount = document.getElementById("ValCount");
const btnClr = document.getElementById("BtnClear");
const btnFwd = document.getElementById("BtnForward");
const btnPrv = document.getElementById("BtnPrevious");
let counter = 0.0;
let counterList = Array(COUNT_HIST_SIZE).fill(0.0);
let counterIndex = 0;
function countClear() {
    if (counter != 0.0) {
        ++counterIndex;
        counterIndex = counterIndex % COUNT_HIST_SIZE;
        counterList[counterIndex] = counter;
        counter = 0.0;
        valCount.textContent = counter.toFixed(3);
        appendMessage("COUNT  " + counter.toFixed(3));
        btnClr.blur();
    }
}
function undoCounter(num) {
    let tCounter = counter;
    counterIndex = (counterIndex + COUNT_HIST_SIZE + num) % COUNT_HIST_SIZE;
    counter = counterList[(counterIndex + COUNT_HIST_SIZE) % COUNT_HIST_SIZE];
    if (tCounter != counter) {
        valCount.textContent = counter.toFixed(3);
        appendMessage("COUNT  " + counter.toFixed(3));
    }
    btnPrv.blur();
    btnFwd.blur();
}
btnClr.addEventListener('click', countClear);
btnFwd.addEventListener('click', () => { undoCounter(1); });
btnPrv.addEventListener('click', () => { undoCounter(-1); });

// 感度
const SENS_MIN = 1 / (2 ** 5);
const SENS_P = 20;
const SENS_RANGE_MAX = 260;
const SENS_RANGE_INIT = 140;
const wSens = document.getElementById("wSens");
const rngSens = document.getElementById("RangeSens");
const valSens = document.getElementById("ValSens");
const valSens2 = document.getElementById("ValSens2");
let lastSens = 0;
function sensChanged() {
    meter.sens = SENS_MIN * 2 ** (rngSens.value / SENS_P);
    updteValSens();
    filterReset = true;
    rngSens.blur();
}
rngSens.max = SENS_RANGE_MAX;
rngSens.min = 1;
rngSens.step = 1;
rngSens.value = SENS_RANGE_INIT;
addRangeListener(wSens, rngSens, sensChanged);

// 設定
const btnConf = document.getElementById("BtnConf");
const divConf = document.getElementById("DivConf");
const btnConfReset = document.getElementById("BtnConfReset");
const chkCorr = document.getElementById("ChkboxCorr");
btnConf.addEventListener('click', () => {
    if (divConf.checkVisibility()) {
        divConf.style.display = "none";
        btnConf.textContent = "Conf";
    } else {
        divConf.style.display = "block";
        btnConf.textContent = "Conf ↑";
    }
    btnConf.blur();
});
btnConfReset.addEventListener('click', () => {
    rngWait.value = AUTOSET_WAIT;
    rngALap.value = AUTOSET_LAPS;
    rngRC.value = RC_FILTER;
    rngSMA.value = SMA_SIZE;
    chkCorr.checked = true;
    autoSetWaitChanged();
    autoSetLapsChanged();
    rcChanged();
    smaChanged();
    updteValSens();
    meter.correct = chkCorr.checked;
    btnConfReset.blur();
});
chkCorr.addEventListener('change', () => {
    meter.correct = chkCorr.checked;
    updteValSens();
    chkCorr.blur();
});
// 自動セット 待ち時間
const wWait = document.getElementById("wWait");
const rngWait = document.getElementById("RangeWait");
const valWait = document.getElementById("ValWait");
let autoSetWait;
function autoSetWaitChanged() {
    autoSetWait = parseFloat(rngWait.value);
    valWait.textContent = autoSetWait.toFixed(1);
    rngWait.blur();
}
rngWait.max = 2.0;
rngWait.min = 0;
rngWait.step = 0.1;
rngWait.value = AUTOSET_WAIT;
addRangeListener(wWait, rngWait, autoSetWaitChanged);
// 自動セット 周回数
const wLap = document.getElementById("wLap");
const rngALap = document.getElementById("RangeLap");
const valALap = document.getElementById("ValLap");
let autoSetLaps;
function autoSetLapsChanged() {
    autoSetLaps = parseInt(rngALap.value);
    valALap.textContent = autoSetLaps;
    rngALap.blur();
}
rngALap.max = 20;
rngALap.min = 1;
rngALap.step = 1;
rngALap.value = AUTOSET_LAPS;
addRangeListener(wLap, rngALap, autoSetLapsChanged);
// RCフィルタ
const wRC = document.getElementById("wRC");
const rngRC = document.getElementById("RangeRC");
const valRC = document.getElementById("ValRC");
let rcFilter;
function rcChanged() {
    rcFilter = parseFloat(rngRC.value);
    valRC.textContent = rcFilter.toFixed(2);
    filterReset = true;
    rngRC.blur();
}
rngRC.max = 0.95;
rngRC.min = 0.20;
rngRC.step = 0.01;
rngRC.value = RC_FILTER;
addRangeListener(wRC, rngRC, rcChanged);
// 移動平均フィルタ
const wSMA = document.getElementById("wSMA");
const rngSMA = document.getElementById("RangeSMA");
const valSMA = document.getElementById("ValSMA");
const valSMAms = document.getElementById("ValSMAms");
let smaSize;
function smaChanged() {
    smaSize = parseFloat(rngSMA.value);
    valSMA.textContent = smaSize;
    valSMAms.textContent = (parseInt(smaSize) * 1000 / 60).toFixed(0) + "[ms]";
    filterReset = true;
    rngSMA.blur();
}
rngSMA.max = 20;
rngSMA.min = 1;
rngSMA.step = 1;
rngSMA.value = SMA_SIZE;
addRangeListener(wSMA, rngSMA, smaChanged);

// Status
const divStatus = document.getElementById("DivStatus");
const valPos = document.getElementById("ValTaPos");
const valTA = document.getElementById("ValTaPc");
const valDiff = document.getElementById("ValTaDiff");
const valLap = document.getElementById("ValLaps");
valTA.textContent = meter.ta.toFixed(3);
valPos.textContent = meter.position.toFixed(3);

// Log
const txtLog = document.getElementById("TextLog");
const btnErace = document.getElementById("BtnErace");
const btnCopy = document.getElementById("BtnCopy");
const btnMark = document.getElementById("BtnMark");
let markID = 1;
function mark() {
    appendMessage("#### " + markID + " ####");
    markID++;
    btnMark.blur();
}
function appendMessage(msg) {
    if (msg == null) {
        txtLog.textContent = txtLog.textContent + "\n";
    } else {
        txtLog.textContent = txtLog.textContent + new Date().toLocaleTimeString() + " " + msg + "\n";
    }
    txtLog.scrollTop = txtLog.scrollHeight;
}
btnErace.addEventListener('click', () => {
    txtLog.textContent = "";
    btnErace.blur();
});
btnCopy.addEventListener('click', () => {
    navigator.clipboard.writeText(txtLog.textContent);
    btnCopy.blur();
});
btnMark.addEventListener('click', mark);

// その他部品
const chkAuto = document.getElementById("ChkboxAuto");
const chkExp = document.getElementById("ChkboxExp");
chkAuto.addEventListener('change', () => { chkAuto.blur(); });
chkExp.addEventListener('change', () => { chkExp.blur(); });
document.addEventListener('keydown', (event) => {
    if ((event.shiftKey) || (event.ctrlKey)) {
        setPosition();
    } else if (event.key === ' ') {
        chkExp.checked = !chkExp.checked;
    } else if (event.key === 'ArrowUp') {
        rngSens.value = parseInt(rngSens.value) + SENS_P;
        sensChanged();
    } else if (event.key === 'ArrowRight') {
        rngSens.value = parseInt(rngSens.value) + 1;
        sensChanged();
    } else if (event.key === 'ArrowDown') {
        rngSens.value = parseInt(rngSens.value) - SENS_P;
        sensChanged();
    } else if (event.key === 'ArrowLeft') {
        rngSens.value = parseInt(rngSens.value) - 1;
        sensChanged();
    } else if (event.key === ',') {
        undoCounter(-1);
    } else if (event.key === '.') {
        undoCounter(1);
    } else if (event.key === 'Delete') {
        countClear();
    } else if ((event.key === 'm') || (event.key === 'M')) {
        mark();
    } else if (event.key === '/') {
        chkAuto.checked = !chkAuto.checked;
    }
});

// スクロール抑止
const body = document.querySelector('body');
body.style.top = -window.scrollY + 'px';
body.style.position = 'fixed';

tickTack();
setInterval(tickTack, 1000);
sensChanged();
autoSetWaitChanged();
autoSetLapsChanged();
rcChanged();
smaChanged();

// メイン
async function start() {
    class LineBreakTransformer {
        constructor() { this.chunks = ""; }
        transform(chunk, controller) {
            this.chunks += chunk;
            const lines = this.chunks.split("\r\n");
            this.chunks = lines.pop();
            lines.forEach((line) => controller.enqueue(line));
        }
        flush(controller) { controller.enqueue(this.chunks); }
    }

    try {
        console.log("connecting...\n");
        const port = await navigator.serial.requestPort();
        await port.open({ baudRate: 15200 });
        let smaBuff = Array(smaSize);
        let meterValue;
        let waitStart = Date.now();
        filterReset = true;

        console.log("connected\n");
        connecting = true;
        btnStart.textContent = "Session Start";
        appendMessage(null);
        appendMessage("CONNECTED\n");

        while (port.readable) {
            const textDecoder = new TextDecoderStream();
            port.readable.pipeTo(textDecoder.writable);
            const reader = textDecoder.readable.pipeThrough(new TransformStream(new LineBreakTransformer())).getReader();

            try {
                while (true) {
                    const { value, done } = await reader.read();
                    if (done) {
                        console.log("done\n");
                        break;
                    }

                    if (filterReset) {
                        smaBuff = Array(smaSize).fill(meter.ta);
                        meterValue = meter.value;
                        filterReset = false;
                    } else {
                        smaBuff = smaBuff.slice(1);
                        smaBuff[smaSize - 1] = parseFloat(value);;
                        let sum = 0;
                        for (let n = 0; n < smaSize; ++n) {
                            sum += smaBuff[n];
                        }
                        meter.ta = sum / smaSize;
                        meterValue = rcFilter * meterValue + (1 - rcFilter) * meter.value;
                    }

                    let outOfRange = true;
                    let nowTime = Date.now();
                    let gaugeValue;
                    let r = 0;
                    if (chkExp.checked) {
                        gaugeValue = Math.floor(mv2gv(meterValue));
                        r = -Math.floor(gaugeValue / GAUGE_MAX_VALUE);
                        if (Math.abs(r) >= autoSetLaps) {
                            gaugeValue = 0;
                        } else {
                            outOfRange = false;
                            waitStart = Date.now();
                            gaugeValue += (r * GAUGE_MAX_VALUE)
                        }
                    } else {
                        if (meterValue >= meter.scaleSize) {
                            gaugeValue = Math.floor(mv2gv(meter.scaleSize));
                        } else if (meterValue < 0) {
                            gaugeValue = Math.floor(mv2gv(0));
                        } else {
                            outOfRange = false;
                            waitStart = Date.now();
                            gaugeValue = Math.floor(mv2gv(meterValue));
                        }
                    }
                    if (chkAuto.checked && outOfRange && ((nowTime - waitStart) >= (autoSetWait * 1000))) {
                        setPosition();
                    } else {
                        gauge.set(gaugeValue);
                        valTA.textContent = meter.ta.toFixed(3);
                        let taDiff = (meter.ta - meter.position);
                        if ((-0.0001 < taDiff) && (taDiff < 0.0001)) {
                            taDiff = 0;
                        }
                        valDiff.textContent = ((taDiff >= 0) ? "+" : "") + taDiff.toFixed(4);
                        valLap.textContent = ((r > 0) ? "+" : "") + r;
                    }
                }
            } catch (error) {
                console.log("stream broken\n");
                console.log(error);
            } finally {
                reader.releaseLock();
                await port.close();
                console.log("disconnected\n");
            }
            gauge.set(mv2gv(0));
            connecting = false;
            if (inSession) {
                startClicked();
            } else {
                btnStart.textContent = "Connect";
            }
            appendMessage(null);
            appendMessage("DISCONNECTED\n");
        }
    } catch (error) {
        console.log("connection failed");
        console.log(error);
    }
}

function setPosition() {
    if (inSession) {
        if (meter.sens != lastSens) {
            appendMessage("SENS  " + meter.sens.toFixed(3));
            lastSens = meter.sens;
        }

        let msg = "pos  " + meter.ta.toFixed(3);
        let dTA = (meter.position - meter.ta);
        if (dTA > 0) {
            counter += dTA;
            ++counterIndex;
            counterIndex = counterIndex % COUNT_HIST_SIZE;
            counterList[counterIndex] = counter;
            msg = msg + "  " + counter.toFixed(3) + "  " + dTA.toFixed(3);
        }
        appendMessage(msg);
    }
    meter.position = meter.ta;
    valCount.textContent = counter.toFixed(3);
    valPos.textContent = meter.position.toFixed(3);
    updteValSens();
    filterReset = true;
}

function addRangeListener(target, rng, fnuc) {
    rng.addEventListener('change', fnuc);
    rng.addEventListener('input', fnuc);
    target.addEventListener("wheel", (event) => {
        event.preventDefault();
        const y = event.deltaY;
        const x = event.deltaX;
        let delta;
        if (Math.abs(y) > Math.abs(x)) {
            delta = -y;
        } else {
            delta = x;
        }
        const value = parseFloat(rng.value) + (parseFloat(rng.step) * delta / 40);
        if (value < parseFloat(rng.min)) {
            rng.value = rng.min;
        } else if (value > parseFloat(rng.max)) {
            rng.value = rng.max;
        } else {
            rng.value = value;
        }
        fnuc();
    });
}

function updteValSens() {
    valSens.textContent = String(meter.sens.toFixed(2)).substring(0, 4)
    let gain = "";
    if (chkCorr.checked) {
        gain = " ×" + String(meter.corrGain.toFixed(2)).substring(0, 4) +
            " (" + String((meter.corrGain * meter.sens).toFixed(2)).substring(0, 4) + ")";
    }
    valSens2.textContent = gain;
}
