/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#pragma once
#include <stdbool.h>

// IO
#define LED_PIN      25
#define VSYS_ADC_PIN 28
#define VSYS_ADC_NO  2

#define CONST_V 3.3f        // ブリッジの定電圧値
#define CONST_R 22000.0f    // ブリッジの固定抵抗

// TA計算用
#define TA_MAX 6.5f        // TA最大値
#define TA_MIN 0.9412f     // TA最小値
#define TA_REG 21250.0f    // TA計算用の抵抗値

// サンプリング用
#define SPS         60                     // 1秒間の送信数
#define SAMPLING_uS (1000 * 1000 / SPS)    // 連続サンプリング時間
#ifdef PICO2
#define ADC_RATE 6030
#define RC       0.95f
#else
#define ADC_RATE 2346
#define RC       0.995f
#endif
#define SMA (ADC_RATE * 3)

void  Device_Init();
float Device_ReadV();
void  Device_SetLED(bool b);
