/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include <stdio.h>

#include "pico/stdlib.h"
#include "pico/time.h"

#include "meter.h"

static bool timeExceeded = false;
static bool timerHandler(repeating_timer_t *t) {
    timeExceeded = true;
    return true;
}

static float v2ta(float v) {
    float result;
    if (v == CONST_V) {
        result = TA_MAX;
    } else {
        float r = v * CONST_R / (CONST_V - v);
        result = r / (r + TA_REG) * (TA_MAX - TA_MIN) + TA_MIN;
    }
    return result;
}

int main() {
    sleep_ms(100);
    stdio_init_all();
    Device_Init();
    sleep_ms(200);
    Device_SetLED(false);

    uint16_t i = 0;
    bool     led = true;
    timeExceeded = false;
    repeating_timer_t timer;

    float    buf[SMA];
    size_t index = 0;
    float    sum = 0.0;
    for (int i = 0; i < SMA; i++) {
        buf[i] = 0;
    }
    add_repeating_timer_us((int64_t)SAMPLING_uS, timerHandler, NULL, &timer);
    float vRc = Device_ReadV();
    while (true) {
        while (timeExceeded == false) {
            vRc = (vRc * RC) + (1.0f - RC) * Device_ReadV();
            sum -= buf[index];
            sum += vRc;
            buf[index] = vRc;
            index = (index + 1) % SMA;
        }
        timeExceeded = false;
        float ta = v2ta(sum / SMA);
        printf("%9.7f\n", ta);
        if (i > SPS) {
            Device_SetLED(led);
            led = !led;
            i = 0;
        }
        i++;
    }
    return 0;
}