/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "hardware/adc.h"
#include "hardware/gpio.h"

#include "meter.h"

void Device_Init() {
    gpio_init(LED_PIN);
    gpio_set_dir(LED_PIN, GPIO_OUT);
    gpio_put(LED_PIN, true);

    adc_init();
    adc_gpio_init(VSYS_ADC_PIN);
    adc_select_input(VSYS_ADC_NO);
}

float Device_ReadV() {
    return adc_read() * (CONST_V / 4096.0f);
}

void Device_SetLED(bool b) {
    gpio_put(LED_PIN, b);
}
