const AUTOSET_WAIT = 0.5; //500[ms] 0-2.0
const AUTOSET_LAPS = 2;   // 1-20
const RC_FILTER = 0.50;   //0.00-0.90
const SMA_SIZE = 6;       //100[ms] 1-60
const AUTO = false;
const EXP = false;
const CORRECT = false;

let connecting = false;
let inSession = false;
let filterReset = false;
let readValue = 0.0;
let wheelSurplus = {};

// メーター
const meter = new SGTMeter();
meter.position = 1.0;
meter.ta = 1.0;

// Gauge TA
const canvGaugeTA = document.getElementById('CanvGaugeTA');
const gaugeTA = new Gauge(canvGaugeTA);
const gaugeOptsTA = {
    angle: -0.5,
    lineWidth: 0.15,
    radiusScale: 1.1,
    pointer: {
        length: 0.54,
        strokeWidth: 0.01,
        color: "#C0C0C0",
    },
    renderTicks: {
        divisions: 7,
        divWidth: 0.2,
        divLength: 1,
        divColor: "#000000",
    },
    staticZones: [
        { strokeStyle: "#E8E8E8", min: 0.95, max: 6.5 },
    ],
};
gaugeTA.maxValue = 7;
gaugeTA.animationSpeed = 1;
gaugeTA.setMinValue(0);
gaugeTA.setOptions(gaugeOptsTA);
gaugeTA.set(1);

// Gauge MAIN
const GAUGE_MAX_VALUE = 180 / 2.5;
const canvGaugeMain = document.getElementById('CanvGaugeMain');
const gaugeMain = new Gauge(canvGaugeMain);
const C_G1 = '#F4F4F4';
const C_G2 = '#E8E8E8';
const C_G3 = '#D8D8D8';
const C_G4 = '#C8C8C8';
const C_G5 = '#B8B8B8';
const C_WH = '#FFFFFF';
const C_BK = '#000000';
const LW_1 = 0.02;
const LW_2 = 0.05;
const gaugeOpts = {
    angle: 0,
    lineWidth: 0.08,
    radiusScale: 1.13,
    pointer: {
        length: 0.503,
        strokeWidth: 0.005,
    },
    renderTicks: {
        divisions: 72,
        divWidth: 0.08,
        divLength: 0.45,
        divColor: C_BK,
    },
    staticZones: [
        { strokeStyle: C_G5, min: mv2gv(0), max: mv2gv(41) },  //全体(上下の枠線)
        { strokeStyle: C_G2, min: mv2gv(0), max: mv2gv(12) },  //RISE
        { strokeStyle: C_WH, min: mv2gv(12), max: mv2gv(17) }, //セット範囲
        { strokeStyle: C_G1, min: mv2gv(17), max: mv2gv(21) }, //SHORT FALL
        { strokeStyle: C_G2, min: mv2gv(21), max: mv2gv(23) }, //
        { strokeStyle: C_G3, min: mv2gv(23), max: mv2gv(29) }, //FALL
        { strokeStyle: C_G4, min: mv2gv(29), max: mv2gv(31) }, //
        { strokeStyle: C_G5, min: mv2gv(31), max: mv2gv(40) }, //LONG FALL
        { strokeStyle: C_G1, min: mv2gv(40), max: mv2gv(41) }, //余白
        { strokeStyle: C_BK, min: mv2gv(2) - LW_2, max: mv2gv(2) + LW_2 }, //開始位置
        { strokeStyle: C_BK, min: mv2gv(15) - LW_2, max: mv2gv(15) + LW_2 }, //SET位置
        { strokeStyle: C_BK, min: mv2gv(26) - LW_2, max: mv2gv(26) + LW_2 }, //FALL位置
        { strokeStyle: C_BK, min: mv2gv(36) - LW_2, max: mv2gv(36) + LW_2 }, //TEST位置
    ]
};
for (let i = 0; i <= 40; i += 2) {
    if ([2, 14, 16, 26, 36, 38].includes(i)) {
        continue;
    }
    gaugeOpts.staticZones.push(
        { strokeStyle: C_BK, min: mv2gv(i) - LW_1, max: mv2gv(i) + LW_1 }
    );
}
gaugeMain.maxValue = GAUGE_MAX_VALUE;
gaugeMain.animationSpeed = 1;
gaugeMain.setMinValue(0);
gaugeMain.setOptions(gaugeOpts);
gaugeMain.set(mv2gv(0));
canvGaugeMain.addEventListener('click', () => { setPosition(); });
function mv2gv(mv) { // meter値 → Gauge値
    return (mv + 16);
}

// 時計とセッション管理
const divCount = document.getElementById("DivCount");
const lblTime = document.getElementById("LblTime");
const valNow = document.getElementById("ValNow");
const valElapsed = document.getElementById("ValElapsed");
const btnStart = document.getElementById("BtnStart");
const timeOffset = new Date(0).getTimezoneOffset() * 60 * 1000;
let totalTime = timeOffset;
let startTime = 0;
let sps = 60;
function startClicked() {
    if (inSession) {
        inSession = false;
        appendMessage("TIME    " + new Date(new Date().getTime() - startTime + timeOffset).toLocaleTimeString());
        appendMessage("ACTION  " + counter.toFixed(3));
        appendMessage("SESSION STOP");

        //Logを保存
        const stampDate = new Date(startTime);
        const stampY = stampDate.getFullYear();
        const stampM = ("0" + (stampDate.getMonth() + 1)).slice(-2);
        const stampD = ("0" + stampDate.getDate()).slice(-2);
        const stampT = ("0" + stampDate.toLocaleTimeString().replaceAll(":", "")).slice(-6);
        const fileName = ("SessionLog-" + stampY + stampM + stampD + "-" + stampT + ".txt");
        const blob = new Blob([txtLog.textContent], { type: "text/plain" });
        const a = document.createElement('a');
        a.href = URL.createObjectURL(blob);
        a.download = fileName;
        a.click();
        appendMessage(null);
        appendMessage("Session log saved.");
        appendMessage("  " + fileName);
        URL.revokeObjectURL(blob);
        a.remove();

        btnMark.disabled = true;
        btnFwd.disabled = true;
        btnPrv.disabled = true;
        divCount.style.color = "gray";
        lblTime.style.color = "gray";
        divCenter.style.fontWeight = "normal";
        btnStart.textContent = connecting ? "Session Start" : "Connect";
    } else if (!connecting) {
        start();
    } else {
        startTime = new Date().getTime();
        counter = 0.0;
        counterList = [counter];
        counterIndex = 0;
        readValue = 0;
        markID = 1;
        valCount.textContent = counter.toFixed(3);
        chkCorr.checked = true;
        txtLog.textContent = "";
        btnMark.disabled = false;
        btnFwd.disabled = true;
        btnPrv.disabled = true;
        divCount.style.color = "black";
        lblTime.style.color = "black";
        divCenter.style.fontWeight = "bold";
        btnStart.textContent = "Session Stop";
        chkCorrChanged();
        setPosition();
        appendMessage("SESSION START");
        appendMessage("SENS  " + valSens.textContent);
        appendMessage("pos  " + valPos.textContent);
        sensChanged = false;
        inSession = true;
    }
    btnStart.blur();
}
function tickTack() {
    const now = new Date();
    valNow.textContent = now.toLocaleDateString() + " - " + now.toLocaleTimeString();
    if (inSession) {
        totalTime += 1000;
        valElapsed.textContent = new Date(totalTime).toLocaleTimeString();
    }
    valSPS.textContent = sps;
    if (sps != 0) {
        valSMAms.textContent = (parseInt(smaSize) * 1000 / sps).toFixed(0) + "[ms]";
    }
    sps = 0;
}
btnStart.addEventListener("click", startClicked);

// アクションカウンター
const valCount = document.getElementById("ValCount");
const btnFwd = document.getElementById("BtnForward");
const btnPrv = document.getElementById("BtnPrevious");
let counter = 0.0;
let counterList;
let counterIndex;
function undoCounter(num) {
    counterIndex += num;
    counter = counterList[counterIndex];
    if (counterIndex == 0) {
        btnPrv.disabled = true;
    } else if (counterIndex >= (counterList.length - 1)) {
        btnFwd.disabled = true;
    } else {
        btnFwd.disabled = false;
        btnPrv.disabled = false;
    }
    valCount.textContent = counter.toFixed(3);
    if (inSession) {
        appendMessage("COUNT               " + counter.toFixed(4));
    }
    btnPrv.blur();
    btnFwd.blur();
}
btnFwd.addEventListener('click', () => { undoCounter(1); });
btnPrv.addEventListener('click', () => { undoCounter(-1); });

// Status
const divCenter = document.getElementById("DivCenter");
const divTA = document.getElementById("DivTA");
const divRead = document.getElementById("DivRead");
const valPos = document.getElementById("ValTaPos");
const valTA = document.getElementById("ValTaPc");
const valDiff = document.getElementById("ValTaDiff");
const valRead = document.getElementById("ValRead");
const valLap = document.getElementById("ValLap");
valTA.textContent = meter.ta.toFixed(3);
valPos.textContent = meter.position.toFixed(3);

// 感度
const SENS_P = 20;
const SENS_MIN = 1 / 2 ** (47 / SENS_P);
const SENS_RANGE_MAX = 187;
const SENS_RANGE_INIT = 87;
const lblSens = document.getElementById("LblSens");
const rngSens = document.getElementById("RngSens");
const valSens = document.getElementById("ValSens");
const btnSensInc = document.getElementById("BtnSensInc");
const btnSensDec = document.getElementById("BtnSensDec");
let sensChanged = false;
function updateSens() {
    meter.sens = SENS_MIN * 2 ** (rngSens.value / SENS_P);
    valSens.textContent = String(meter.sens.toFixed(2)).substring(0, 4);
    let gain = "×";
    if (chkCorr.checked) {
        gain = gain + String(meter.corrGain.toFixed(2)).substring(0, 4) +
            " (" + String((meter.corrGain * meter.sens).toFixed(2)).substring(0, 4) + ")";
    } else {
        gain = gain + "1";
    }
    valGain.textContent = gain;
    sensChanged = true;
    rngSens.blur();
}
rngSens.max = SENS_RANGE_MAX;
rngSens.min = 1;
rngSens.step = 1;
rngSens.value = SENS_RANGE_INIT;
addRangeListener(lblSens, rngSens, updateSens);
addRangeListener(canvGaugeMain, rngSens, updateSens);
btnSensInc.addEventListener('click', () => {
    rngSens.value = parseInt(rngSens.value) + 1;
    updateSens();
    btnSensInc.blur();
});
btnSensDec.addEventListener('click', () => {
    rngSens.value = parseInt(rngSens.value) - 1;
    updateSens();
    btnSensDec.blur();
});

// 自動SET、 拡張モード、 感度補正モード
const chkAuto = document.getElementById("ChkAuto");
const chkExp = document.getElementById("ChkExp");
const chkCorr = document.getElementById("ChkCorr");
chkAuto.checked = AUTO;
chkExp.checked = EXP;
chkCorr.checked = CORRECT;
chkAuto.addEventListener('change', () => { chkAuto.blur(); });
chkExp.addEventListener('change', () => { chkExp.blur(); });
chkCorr.addEventListener('change', chkCorrChanged);
function chkCorrChanged() {
    meter.correct = chkCorr.checked;
    updateSens();
    chkCorr.blur();
}
meter.correct = chkCorr.checked;

// 設定
const divConf = document.getElementById("DivConf");
const btnConf = document.getElementById("BtnConf");
const btnConfReset = document.getElementById("BtnConfReset");
btnConf.addEventListener('click', () => {
    if (divConf.checkVisibility()) {
        divConf.style.display = "none";
        btnConf.textContent = "Conf";
    } else {
        divConf.style.display = "block";
        btnConf.textContent = "Conf ↑";
    }
    btnConf.blur();
});
btnConfReset.addEventListener('click', () => {
    rngWait.value = AUTOSET_WAIT;
    rngMaxLap.value = AUTOSET_LAPS;
    rngRC.value = RC_FILTER;
    rngSMA.value = SMA_SIZE;
    autoSetWaitChanged();
    maxLapsChanged();
    rcChanged();
    smaChanged();
    updateSens();
    btnConfReset.blur();
});
// 自動セット 待ち時間
const lblWait = document.getElementById("LblWait");
const rngWait = document.getElementById("RngWait");
const valWait = document.getElementById("ValWait");
let autoSetWait;
function autoSetWaitChanged() {
    autoSetWait = parseFloat(rngWait.value);
    valWait.textContent = autoSetWait.toFixed(1);
    rngWait.blur();
}
rngWait.max = 2.0;
rngWait.min = 0;
rngWait.step = 0.1;
rngWait.value = AUTOSET_WAIT;
addRangeListener(lblWait, rngWait, autoSetWaitChanged);
// 最大周回数
const lblMaxLap = document.getElementById("LblMaxLap");
const rngMaxLap = document.getElementById("RngMaxLap");
const valMaxLap = document.getElementById("ValMaxLap");
let maxLap;
function maxLapsChanged() {
    maxLap = parseInt(rngMaxLap.value);
    valMaxLap.textContent = maxLap;
    rngMaxLap.blur();
}
rngMaxLap.max = 20;
rngMaxLap.min = 0;
rngMaxLap.step = 1;
rngMaxLap.value = AUTOSET_LAPS;
addRangeListener(lblMaxLap, rngMaxLap, maxLapsChanged);
// RCフィルタ
const lblRC = document.getElementById("LblRC");
const rngRC = document.getElementById("RngRC");
const valRC = document.getElementById("ValRC");
let rcFilter;
function rcChanged() {
    rcFilter = parseFloat(rngRC.value);
    valRC.textContent = rcFilter.toFixed(2);
    rngRC.blur();
}
rngRC.max = 0.90;
rngRC.min = 0.00;
rngRC.step = 0.01;
rngRC.value = RC_FILTER;
addRangeListener(lblRC, rngRC, rcChanged);
// 移動平均フィルタ
const wSMA = document.getElementById("LblSMA");
const rngSMA = document.getElementById("RngSMA");
const valSMA = document.getElementById("ValSMA");
const valSMAms = document.getElementById("ValSMAms");
let smaSize;
function smaChanged() {
    smaSize = parseFloat(rngSMA.value);
    valSMA.textContent = smaSize;
    filterReset = true;
    rngSMA.blur();
}
rngSMA.max = 20;
rngSMA.min = 1;
rngSMA.step = 1;
rngSMA.value = SMA_SIZE;
addRangeListener(wSMA, rngSMA, smaChanged);
// sps表示
const valSPS = document.getElementById("ValSPS");
// gain表示
const valGain = document.getElementById("ValGain");

// Log
const txtLog = document.getElementById("TxtLog");
const btnMark = document.getElementById("BtnMark");
let markID = 1;
function mark() {
    appendMessage("######## " + markID + " ########");
    markID++;
    btnMark.blur();
}
function appendMessage(msg) {
    if (msg == null) {
        txtLog.textContent = txtLog.textContent + "\n";
    } else {
        txtLog.textContent = txtLog.textContent + new Date().toLocaleTimeString() + " " + msg + "\n";
    }
    txtLog.scrollTop = txtLog.scrollHeight;
}
btnMark.addEventListener('click', mark);

// キーボードイベント
document.addEventListener('keydown', (event) => {
    if (event.key === 'ArrowUp') {
        rngSens.value = parseInt(rngSens.value) + SENS_P;
        updateSens();
    } else if (event.key === 'ArrowRight') {
        rngSens.value = parseInt(rngSens.value) + 1;
        updateSens();
    } else if (event.key === 'ArrowDown') {
        rngSens.value = parseInt(rngSens.value) - SENS_P;
        updateSens();
    } else if (event.key === 'ArrowLeft') {
        rngSens.value = parseInt(rngSens.value) - 1;
        updateSens();
    } else if (event.key === ' ') {
        setPosition();
    } else if (event.key === ',') {
        undoCounter(-1);
    } else if (event.key === '.') {
        undoCounter(1);
    } else if ((event.key === 'm') || (event.key === 'M')) {
        mark();
    } else if ((event.key === 'z') || (event.key === 'Z')) {
        chkAuto.checked = !chkAuto.checked;
    } else if ((event.key === 'x') || (event.key === 'X')) {
        chkExp.checked = !chkExp.checked;
    } else if ((event.key === 'c') || (event.key === 'C')) {
        chkCorr.checked = !chkCorr.checked;
        chkCorrChanged();
    }
});

// スクロール抑止
const body = document.querySelector('body');
body.style.top = -window.scrollY + 'px';
body.style.position = 'fixed';

tickTack();
setInterval(tickTack, 1000);
updateSens();
autoSetWaitChanged();
maxLapsChanged();
rcChanged();
smaChanged();

// メイン
async function start() {
    class LineBreakTransformer {
        constructor() { this.chunks = ""; }
        transform(chunk, controller) {
            this.chunks += chunk;
            const lines = this.chunks.split("\r\n");
            this.chunks = lines.pop();
            lines.forEach((line) => controller.enqueue(line));
        }
        flush(controller) { controller.enqueue(this.chunks); }
    }

    try {
        console.log("connecting...\n");
        const port = await navigator.serial.requestPort();
        await port.open({ baudRate: 15200 });
        let smaBuff = Array(smaSize);
        let waitStart = Date.now();
        filterReset = true;

        console.log("connected\n");
        connecting = true;
        btnStart.textContent = "Session Start";
        divTA.style.color = "black";
        divRead.style.color = "black";
        appendMessage("CONNECTED\n");

        while (port.readable) {
            const textDecoder = new TextDecoderStream();
            port.readable.pipeTo(textDecoder.writable);
            const reader = textDecoder.readable.pipeThrough(new TransformStream(new LineBreakTransformer())).getReader();

            try {
                while (true) {
                    const { value, done } = await reader.read();
                    if (done) {
                        console.log("done\n");
                        break;
                    }

                    let ta = parseFloat(value);
                    if (isNaN(ta) || (ta < 0.5) || (ta > 7.0)) {
                        continue;
                    }

                    sps++;
                    if (filterReset) {
                        smaBuff = Array(smaSize).fill(ta);
                        meter.ta = ta;
                        filterReset = false;
                    } else {
                        smaBuff.push(rcFilter * smaBuff[smaSize - 1] + (1 - rcFilter) * ta)
                        smaBuff.shift();
                        let sum = 0;
                        for (let n = 0; n < smaSize; ++n) {
                            sum += smaBuff[n];
                        }
                        meter.ta = sum / smaSize;
                    }
                    const meterValue = meter.value;

                    let outOfRange = true;
                    const nowTime = Date.now();
                    let gaugeValue;
                    let r = 0;
                    if (chkExp.checked) {
                        gaugeValue = mv2gv(meterValue);
                        r = Math.floor(gaugeValue / GAUGE_MAX_VALUE);
                        if (r > maxLap) {
                            gaugeValue = GAUGE_MAX_VALUE;
                            r = maxLap;
                        } else if (-r > maxLap) {
                            gaugeValue = 0;
                            r = -maxLap;
                        } else {
                            outOfRange = false;
                            waitStart = nowTime;
                            gaugeValue -= (r * GAUGE_MAX_VALUE)
                        }
                    } else {
                        if (meterValue >= meter.scaleSize) {
                            gaugeValue = mv2gv(meter.scaleSize);
                        } else if (meterValue < 0) {
                            gaugeValue = mv2gv(0);
                        } else {
                            outOfRange = false;
                            waitStart = nowTime;
                            gaugeValue = mv2gv(meterValue);
                        }
                    }

                    if (chkAuto.checked && outOfRange && ((nowTime - waitStart) >= (autoSetWait * 1000))) {
                        setPosition();
                        waitStart = nowTime;
                    } else {
                        let read = ((meterValue - 15) / 8);
                        if (Math.abs(read) > Math.abs(readValue)) {
                            readValue = read;
                        }
                        let readS;
                        if (meterValue > meter.scaleSize) {
                            readS = "++  ";
                        } else if (meterValue < 0) {
                            readS = "--  ";
                        } else {
                            if ((Math.abs(read) < 0.01)) {
                                read = 0.0;
                            }
                            readS = ((read >= 0) ? "+" : "") + read.toFixed(2);
                        }
                        valRead.textContent = readS;

                        gaugeMain.set(gaugeValue);
                        gaugeTA.set(meter.ta);
                        valTA.textContent = meter.ta.toFixed((divConf.style.display === "block") ? 8 : 3);
                        let taDiff = (meter.ta - meter.position);
                        if ((-0.0001 < taDiff) && (taDiff < 0.0001)) {
                            taDiff = 0;
                        }
                        valDiff.textContent = ((taDiff >= 0) ? "+" : "") + taDiff.toFixed(4);
                        valLap.textContent = ((r > 0) ? "+" : "") + r;
                    }
                }
            } catch (error) {
                console.log("stream broken\n");
                console.log(error);
            } finally {
                reader.releaseLock();
                await port.close();
                console.log("disconnected\n");
            }
            gaugeMain.set(mv2gv(0));
            connecting = false;
            divTA.style.color = "gray";
            divRead.style.color = "gray";
            if (inSession) {
                startClicked();
            } else {
                btnStart.textContent = "Connect";
            }
            appendMessage(null);
            appendMessage("DISCONNECTED\n");
            appendMessage(null);
        }
    } catch (error) {
        console.log("connection failed");
        console.log(error);
    }
}

function setPosition() {
    if (inSession) {
        if (sensChanged) {
            appendMessage("SENS  " + valSens.textContent + (chkCorr.checked ? "" : " (CORR OFF)"));
        }
        let readS;
        if (readValue >= ((meter.scaleSize - 15) / 8)) {
            readS = "  ++ ";
        } else if (readValue <= ((0 - 15) / 8)) {
            readS = "  -- ";
        } else {
            readS = (readValue >= 0 ? " " : "") + readValue.toFixed(2);
        }
        let msg = "pos  " + meter.ta.toFixed(3) + "  " + readS;
        let dTA = (meter.position - meter.ta);
        if (dTA > 0.0001) {
            counter += dTA;
            ++counterIndex;
            if (counterList.length <= counterIndex) {
                counterList.push(counter);
            } else {
                counterList[counterIndex] = counter;
            }
            if (counterIndex >= (counterList.length - 1)) {
                btnFwd.disabled = true;
            }
            btnPrv.disabled = false;
            msg = msg + "   " + counter.toFixed(4);
        }
        appendMessage(msg);
        readValue = 0.0;
    }
    meter.position = meter.ta;
    valCount.textContent = counter.toFixed(3);
    valPos.textContent = meter.position.toFixed(3);
    updateSens();
    sensChanged = false;
    filterReset = true;
}

function addRangeListener(target, rng, fnuc) {
    wheelSurplus[rng] = 0;
    rng.addEventListener('change', fnuc);
    rng.addEventListener('input', fnuc);
    target.addEventListener("wheel", (event) => {
        if (!event.ctrlKey) {
            const y = event.deltaY;
            const x = event.deltaX;
            const delta = (Math.abs(y) > Math.abs(x)) ? (-y) :  x;
            const step = (wheelSurplus[rng] + delta) / 90;
            wheelSurplus[rng] = (wheelSurplus[rng] + delta) % 80;
            const value = parseFloat(rng.value) + (parseFloat(rng.step) * step);
            if (value < parseFloat(rng.min)) {
                rng.value = rng.min;
            } else if (value > parseFloat(rng.max)) {
                rng.value = rng.max;
            } else {
                rng.value = value;
            }
            fnuc();
        }
    });
}
