/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#pragma once
#include <stdbool.h>

#include "mcp356xR.h"

// IO
#define LED_PIN        25
#define SPI0_SCK       18
#define SPI0_MOSI      19
#define SPI0_MISO      16
#define SPI0_CS        17
#define SPI0_SPEED_kHz 400

#define CONST_V 2.4f        // ブリッジの定電圧値
#define CONST_R 22000.0f    // ブリッジの固定抵抗

// TA計算用
#define TA_MAX 6.5f        // TA最大値
#define TA_MIN 0.9412f     // TA最小値
#define TA_REG 21250.0f    // TA計算用の抵抗値

// サンプリング用
#define SPS         60                     // 1秒間の送信数
#define SAMPLING_uS (1000 * 1000 / SPS)    // 連続サンプリング時間
#define ADC_SPS     MCP356xR_SPS_4800
#define ADC_RATE    (4800 / SPS)
#define SMA         (ADC_RATE * 3)
#define RC          0.90f

void  Device_Init();
float Device_ReadV();
void  Device_SetLED(bool b);
