/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "hardware/gpio.h"

#include "meter.h"
#include "mcp356xR.h"

static float corr = 1.0f;    // 校正用

void Device_Init() {
    gpio_init(LED_PIN);
    gpio_set_dir(LED_PIN, GPIO_OUT);
    gpio_put(LED_PIN, true);

    spi_init(spi0, SPI0_SPEED_kHz * 1000);
    gpio_set_function(SPI0_SCK, GPIO_FUNC_SPI);
    gpio_set_function(SPI0_MOSI, GPIO_FUNC_SPI);
    gpio_set_function(SPI0_MISO, GPIO_FUNC_SPI);
    gpio_init(SPI0_CS);
    gpio_set_dir(SPI0_CS, GPIO_OUT);
    gpio_put(SPI0_CS, 1);

    MCP356xR_Init(spi0, SPI0_CS, ADC_SPS);
    MCP356xR_Select(MCP356xR_CH_REF_P, MCP356xR_CH_REF_N);
    MCP356xR_Start();
    float v = MCP356xR_Read(true);
    corr = MCP356xR_REFV / v;
    MCP356xR_Select(MCP356xR_CH_0, MCP356xR_CH_REF_N);
    MCP356xR_Start();
}

float Device_ReadV() {
    return MCP356xR_Read(true) * corr;
}

void Device_SetLED(bool b) {
    gpio_put(LED_PIN, b);
}
