/*
 * Copyright (c) 2024 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "hardware/i2c.h"

#include "mcp4726.h"

static i2c_inst_t *i2c;
static uint8_t     COMMAND[2];

void MCP4726_Init(i2c_inst_t *i, uint8_t a) {
    i2c = i;
    COMMAND[0] = MCP4726_INIT_CMD;
    i2c_write_blocking(i2c, a, COMMAND, 1, false);
}

int16_t MCP4726_Set(uint8_t a, int16_t value) {
    int16_t pos = value;
    if (value < MDP4726_MIN_VALUE) {
        pos = MDP4726_MIN_VALUE;
    } else if (value > MDP4726_MAX_VALUE) {
        pos = MDP4726_MAX_VALUE;
    }
    COMMAND[0] = (uint8_t)(pos >> 8);
    COMMAND[1] = (uint8_t)(pos & 0xFF);
    i2c_write_blocking(i2c, a, COMMAND, 2, false);
    return pos;
}
