/*
 * Copyright (c) 2024 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "hardware/i2c.h"

#include "aqm1602.h"

static uint8_t addr;    // 0x3e;

static uint8_t     Buff[18];
static i2c_inst_t *i2c;

static void send(int size) {
    i2c_write_blocking(i2c, addr, Buff, size, false);
}

void LCD_Init(i2c_inst_t *i, uint8_t a) {
    i2c = i;
    addr = a;

    Buff[0] = 0x38;
    Buff[1] = 0x39;
    Buff[2] = 0x14;
    Buff[3] = 0x73;    // contrast 0x70~0x7F
    Buff[4] = 0x56;
    Buff[5] = 0x6C;
    send(6);
    sleep_ms(200);

    Buff[0] = 0x38;
    Buff[1] = 0x01;
    Buff[2] = 0x0c;
    send(3);
    sleep_ms(20);

    Buff[0] = 0x00;
    Buff[1] = 0x38;
    Buff[2] = 0x39;
    Buff[3] = 0x14;
    Buff[4] = 0x70;    // contrast 0x70~0x7F
    Buff[5] = 0x56;
    Buff[6] = 0x6C;
    send(7);
    sleep_ms(200);

    Buff[0] = 0x38;
    Buff[1] = 0x0c;
    Buff[2] = 0x01;
    sleep_ms(20);
    send(3);
}

void LCD_Clear() {
    LCD_SelectRow(1);
    LCD_Write("                 ");
    LCD_SelectRow(2);
    LCD_Write("                 ");
    LCD_SelectRow(1);
}

void LCD_SelectRow(int i) {
    if (i == 1) {
        Buff[0] = 0x06;
        Buff[1] = 0x80;
    } else {
        Buff[0] = 0x06;
        Buff[1] = 0xc0;
    }
    send(2);
}

void LCD_Write(char *s) {
    if (*s != 0) {
        Buff[0] = 0x40;
        volatile int i;
        for (i = 1; i <= 17; ++i) {
            if (*s == 0) {
                break;
            } else {
                Buff[i] = *s++;
            }
        }
        send(i);
    }
}
