/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#pragma once

// 内部IO
#define LED_PIN        25
#define VBUS_SENSE_PIN 24
#define VSYS_ADC_PIN   29
#define VSYS_ADC_NO    3

// ロータリーエンコーダ
#define SE_RE1 26    // 感度用 B相
#define SE_RE2 27    // 感度用 A相
#define TA_RE1 20    // TA用 B相
#define TA_RE2 21    // TA用 A相

// ボタン
#define BTN1 2
#define BTN2 3
#define BTN3 4
#define BTN4 5
#define BTN5 6
#define BTN6 7
#define BTN7 8
#define BTN8 9
#define BTN9 14

#define BUTTON_SET     BTN1    // TAセット
#define BUTTON_AUTO    BTN2    // 自動モード切替
#define BUTTON_SENS    BTN3    // 感度切替
#define BUTTON_POWER   BTN4    // 電源表示
#define BUTTON_COUNT   BTN5    // カウントモード切替
#define BUTTON_CLEAR   BTN6    // TAカウンタークリア
#define BUTTON_BACK    BTN7    // TAカウンターを履歴から戻す
#define BUTTON_FORWARD BTN8    // 戻したTAカウンターを進める
#define BUTTON_SET2    BTN9    // TAセット2

// ロータリーエンコーダ移動方向判定用
#define ROTARY_DIRECTION \
    {0, 1, -1, 0, -1, 0, 0, 1, 1, 0, 0, -1, 0, -1, 1, 0}

// 時間
#define SAMPLING_uS        (100 * 1000)     // 連続サンプリング時間 → イベントチェック間隔
#define UPDATE_uS          (500 * 1000)     // LCD更新間隔・・・0.5秒
#define EVENT_WAIT_uS      (100 * 1000)     // 同じイベントの連続実行を抑止する時間
#define POWER_VIEW_WAIT_uS (2000 * 1000)    // 起動時に電源状態を表示する時間・・・2秒

// 自動セット待ち時間
#define AUTO_SET_WAIT_uS     (500 * 1000)         // デフォルト0.5秒
#define AUTO_SET_WAIT_MAX_uS (3 * 1000 * 1000)    // 最大待ち時間3秒
#define AUTO_SET_ADJ_STEP    (100 * 1000)         // 0.1秒

// 自動セットブロック
#define TA_HIST_uS   (1000 * 1000)                 // TA履歴を保存期間
#define TA_HIST_SIZE (TA_HIST_uS / SAMPLING_uS)    // TA履歴サイズ

// TA関連
#define TA_MAX          6.5f       // TA最大値
#define TA_MIN          0.9412f    // TA最小値
#define PC_TA_MAX       6.45f      // PCが缶を持っていないと判定する閾値
#define TA_PAUSE_RANGE  0.800f     // 履歴中の範囲がこれより大きい場合、カウント停止
#define COUNT_HIST_SIZE 20         // TAカウンタ履歴サイズ
#define TA_RE_STEP      1.0f       // トーンアーム操作時の針の移動量

// TA値計算用
#define CONST_V 2.4f        // ブリッジの定電圧値 ・・・ MCP356xRの内部参照電圧
#define CONST_R 21250.0f    // ブリッジの固定抵抗値

// 感度関連
#define SENS_NORM_INITIAL     4.0f       // 通常モードの初期値
#define SENS_LOW_INITIAL      0.1f       // 低感度モード時の初期値
#define SENS_MIN              0.002f     // 感度の最小値
#define SENS_MAX              256.0f     // 感度の最大値
#define SENS_R_BASE           3125.0F    // 感度計算用抵抗値
#define SENS_R_TA20           5000.0F    // TA2.0のPC抵抗値
#define SENS_RE_RATIO         1.05f      // 感度操作の増減割合
#define CORRECT_R_FALL        860.0F     // TA2.5、感度4(補正前)でFALL目盛までリードする抵抗値
#define CORRECT_TA_BASE       2.0f       // 補正倍率を1とするTA値(感度はTA2.0を基準に定義される)
#define CORRECT_TA_LOW_TH     2.6f       // 補正を緩くする低いほうの境界値
#define CORRECT_TA_HIGH_TH    4.3f       // 補正を緩くする高いほうの境界値
#define CORRECT_TA_LOW_RATIO  0.1f       // 低いほうの補正を穏やかにする割合
#define CORRECT_TA_HIGH_RATIO 0.6f       // 高いほうの補正を穏やかにする割合

// メーター目盛   左端=0, セット位置=15,  右端=40
#define METER_SCALE_MAX  40.0f    // 右端の目盛位置
#define METER_SCALE_SET  15.0f    // セット位置
#define METER_SCALE_SIZE 43.0f    // 右端の余白を3目盛分とする
