/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#pragma once

// I2C0 DAC用
#define I2C0_SPEED_kHz 400    // 2000kHzぐらいが限界値
#define I2C0_SDA_PIN   12
#define I2C0_SCL_PIN   13

// I2C1 LCD用
#define I2C1_SPEED_kHz 360    // LCDは最大400kHz
#define I2C1_SDA_PIN   10
#define I2C1_SCL_PIN   11

// I2Cアドレス
#define ADDR_MCP4726 0x60
#define ADDR_LCD     0x3e

// DAC
#define DAC_MAX_VALUE 4095.0f
#define DAC_MIN_VALUE 0.0f

// SPI0 ADC用
#define SPI0_SPEED_kHz 400
#define SPI0_SCK       18
#define SPI0_MOSI      19
#define SPI0_MISO      16
#define SPI0_CS        17

// ADC
#define ADC_WAIT_US (1000 * 1000 / 59)    // ADC変換待ち時間 空読みが発生しないように変換時間より長くする

void    initDevice();
void    adcStart();
void    adcStop();
float   adcRead();
int16_t meterDacSet(float value);
void    lcdPrint(uint8_t row, char *mess);
