/*
 * Copyright (c) 2025 ShinGeTsu Meter.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "hardware/spi.h"
#pragma once

// デバイスアドレス 7-6
#define MCP356xR_DEVADDR (0b01 << 6)
// レジスタアドレス 5-2
#define MCP356xR_REG_ADCDATA  (0x0 << 2)
#define MCP356xR_REG_CONFIG0  (0x1 << 2)
#define MCP356xR_REG_CONFIG1  (0x2 << 2)
#define MCP356xR_REG_CONFIG2  (0x3 << 2)
#define MCP356xR_REG_CONFIG3  (0x4 << 2)
#define MCP356xR_REG_IRQ      (0x5 << 2)
#define MCP356xR_REG_MUX      (0x6 << 2)
#define MCP356xR_REG_SCAN     (0x7 << 2)
#define MCP356xR_REG_TIMER    (0x8 << 2)
#define MCP356xR_REG_OFFSET   (0x9 << 2)
#define MCP356xR_REG_GAIN     (0xA << 2)
#define MCP356xR_REG_RESERVE1 (0xB << 2)    // for errata
#define MCP356xR_REG_RESERVE2 (0xC << 2)
#define MCP356xR_REG_LOCK     (0xD << 2)
#define MCP356xR_REG_RESERVE3 (0xE << 2)
#define MCP356xR_REG_CRC      (0xF << 2)
// 高速コマンド 5-2
#define MCP356xR_CMD_START         (0b1010 << 2)
#define MCP356xR_CMD_STANDBY       (0b1011 << 2)
#define MCP356xR_CMD_ADC_SHUTDOWN  (0b1100 << 2)
#define MCP356xR_CMD_FULL_SHUTDOWN (0b1101 << 2)
#define MCP356xR_CMD_RESET         (0b1110 << 2)
// コマンドタイプ
#define MCP356xR_FAST_CMD    (0b00)
#define MCP356xR_READ_STATIC (0b01)
#define MCP356xR_WRITE_INC   (0b10)
#define MCP356xR_READ_INC    (0b11)

// MUX
#define MCP356xR_CH_0     (0b0000)
#define MCP356xR_CH_1     (0b0001)
#define MCP356xR_CH_2     (0b0010)
#define MCP356xR_CH_3     (0b0011)
#define MCP356xR_CH_4     (0b0100)
#define MCP356xR_CH_5     (0b0101)
#define MCP356xR_CH_6     (0b0110)
#define MCP356xR_CH_7     (0b0111)
#define MCP356xR_CH_AGRD  (0b1000)
#define MCP356xR_CH_AVDD  (0b1001)
#define MCP356xR_CH_REF_P (0b1011)
#define MCP356xR_CH_REF_N (0b1100)

// OSR
#define MCP356xR_OSR_49152 (0b1101 << 2)    // 25SPS / 24bit
#define MCP356xR_OSR_40960 (0b1100 << 2)    // 30SPS
#define MCP356xR_OSR_24576 (0b1011 << 2)    // 50SPS
#define MCP356xR_OSR_20480 (0b1010 << 2)    // 60SPS
#define MCP356xR_OSR_16384 (0b1001 << 2)    // 75SPS
#define MCP356xR_OSR_8192  (0b1000 << 2)    // 150SPS
#define MCP356xR_OSR_4096  (0b0111 << 2)    // 300SPS
#define MCP356xR_OSR_2048  (0b0110 << 2)    // 600SPS
#define MCP356xR_OSR_1024  (0b0101 << 2)    // 1200SPS
#define MCP356xR_OSR_0512  (0b0100 << 2)    // 2400SPS
#define MCP356xR_OSR_0256  (0b0011 << 2)    // 4800SPS / 24bit
#define MCP356xR_OSR_0128  (0b0010 << 2)    // 9600SPS / 22bit

// IRQ
#define MCP356xR_IRQ_DR_STATUS (0b1 << 6)    // DATA_READYステータス用マスク 0:読み出し可能

// レジスタ設定値
#define MCP356xR_VAL_CONFIG0 (0b10100000)                         // 内部REF,内部クロック,電流印可なし,シャットダウンモード
#define MCP356xR_VAL_CONFIG1 (0b00000000 | MCP356xR_OSR_20480)    // AMCLK = MCLK, 60SPS
#define MCP356xR_VAL_CONFIG2 (0b10001011)                         // 電流1倍,GAIN:1,自動ゼロ調整無効
#define MCP356xR_VAL_CONFIG3 (0b11100011)                         // 連続変換モード,32ビット負号拡張,オフセット校正有効
#define MCP356xR_VAL_IRQ     (0b00000111)                         // IRQ出力を選択する, 非アクティブ状態は論理High,高速コマンド有効,変換開始割り込み無効

/**電圧計算用 */
#define MCP356xR_REFV   2.4f    // 内部REF電圧
#define MCP356xR_ADCMAX (8388608.0f)

void  MCP356xR_Init(spi_inst_t *s, uint cspin);
void  MCP356xR_Select(uint8_t chp, uint8_t chn);
float MCP356xR_Read(bool wait);
void  MCP356xR_Start();
void  MCP356xR_Stop();
